/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.util;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.util.LogListenerInterface;
import java.util.ArrayList;
import java.util.Iterator;

public class LogListener {
    private static final String TRACE_MASKT = "XPALOG T";
    private static final String TRACE_MASKF = "XPALOG F";
    private static final String TRACE_MASKD = "XPALOG D";
    private ArrayList _logEvent = new ArrayList(4);
    private ArrayList _listenerList = new ArrayList(4);
    private Object _requestLock = new Object();
    private static LogListener _myself = null;
    private static final int _logCap = 100;
    private static boolean _capped = false;

    private LogListener() {
        this.startThread();
    }

    private void startThread() {
        Thread myThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Trace.trace(LogListener.TRACE_MASKD, "request thread running");
                ArrayList clonedList = null;
                while (true) {
                    LogData element = null;
                    Object object = LogListener.this._requestLock;
                    synchronized (object) {
                        while (LogListener.this._logEvent.isEmpty()) {
                            Trace.trace(LogListener.TRACE_MASKD, "list is empty");
                            try {
                                Trace.trace(LogListener.TRACE_MASKD, "wait");
                                LogListener.this._requestLock.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                        Trace.trace(LogListener.TRACE_MASKD, "got something to do. get it.");
                        element = (LogData)LogListener.this._logEvent.remove(0);
                        clonedList = (ArrayList)LogListener.this._listenerList.clone();
                    }
                    Iterator it = clonedList.iterator();
                    while (it.hasNext()) {
                        Trace.trace(LogListener.TRACE_MASKD, "calling listener" + it);
                        ((LogListenerInterface)it.next()).handle(element.logClass, element.logType, element.user, element.timestamp);
                    }
                    clonedList = null;
                }
            }
        });
        myThread.setDaemon(true);
        myThread.setName("Log Listener Thread");
        myThread.start();
    }

    public static synchronized LogListener getLogListener() {
        if (_myself == null) {
            _myself = new LogListener();
        }
        return _myself;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postIt(byte logClass, byte logType, short user, long timestamp) {
        Trace.trace(TRACE_MASKD, "post event to the list");
        LogData anElement = new LogData();
        anElement.logClass = logClass;
        anElement.logType = logType;
        anElement.user = user;
        anElement.timestamp = timestamp;
        Object object = this._requestLock;
        synchronized (object) {
            int queueSize = this._logEvent.size();
            Trace.trace(TRACE_MASKF, "the queue size is " + queueSize);
            if (queueSize < 100 && !_capped) {
                Trace.trace(TRACE_MASKF, "not over or capped add it to the queue");
                this._logEvent.add(anElement);
                this._requestLock.notifyAll();
            } else {
                Trace.trace(TRACE_MASKF, "over the limit stop processing the entries");
                _capped = true;
                if (queueSize == 0) {
                    _capped = false;
                    Trace.trace(TRACE_MASKF, "drained. Reset the capped flag.");
                } else {
                    Trace.trace(TRACE_MASKF, "still not drained");
                }
            }
        }
    }

    public static void handle(byte logClass, byte logType, short user, long timestamp) {
        Trace.trace(TRACE_MASKD, "--> Handle log event");
        LogListener logListener = LogListener.getLogListener();
        logListener.postIt(logClass, logType, user, timestamp);
        Trace.trace(TRACE_MASKD, "<-- Handle log event");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LogListenerInterface listener) {
        Trace.trace(TRACE_MASKF, "<--> adding log listener " + listener);
        Object object = this._requestLock;
        synchronized (object) {
            if (this._listenerList.contains(listener)) {
                Trace.trace(TRACE_MASKF, listener + " is already in the list don't add");
            } else {
                Trace.trace(TRACE_MASKF, "added " + listener);
                this._listenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LogListenerInterface listener) {
        Trace.trace(TRACE_MASKF, "<--> removing log listener " + listener);
        Object object = this._requestLock;
        synchronized (object) {
            this._listenerList.remove(listener);
        }
    }

    static class LogData {
        public byte logClass;
        public byte logType;
        public short user;
        public long timestamp;

        LogData() {
        }
    }
}

